

<?php $__env->startSection('title', 'Messages'); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .inbox-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 16px;
        }

        .inbox-title {
            font-size: 20px;
            font-weight: 800;
            color: #1e3a5f;
        }

        .demo-btn {
            padding: 8px 14px;
            background: #f0f9ff;
            color: #00aff5;
            border-radius: 10px;
            font-size: 11px;
            font-weight: 700;
            text-decoration: none;
        }

        .alert-success {
            background: #d1fae5;
            color: #065f46;
            padding: 12px;
            border-radius: 10px;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 12px;
        }

        .conversation-list {
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .conversation-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px;
            background: white;
            border-radius: 14px;
            text-decoration: none;
            color: inherit;
            box-shadow: 0 2px 10px rgba(0,0,0,0.04);
            transition: all 0.2s ease;
        }

        .conversation-item:active {
            transform: scale(0.98);
            background: #f8fafc;
        }

        .conversation-avatar {
            width: 50px;
            height: 50px;
            border-radius: 14px;
            background: linear-gradient(135deg, #00aff5, #10b981);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            font-weight: 800;
            color: white;
            flex-shrink: 0;
        }

        .conversation-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 14px;
        }

        .conversation-content {
            flex: 1;
            min-width: 0;
        }

        .conversation-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 4px;
        }

        .conversation-name {
            font-size: 14px;
            font-weight: 700;
            color: #1e3a5f;
        }

        .conversation-time {
            font-size: 10px;
            color: #94a3b8;
        }

        .conversation-preview {
            font-size: 12px;
            color: #64748b;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .conversation-meta {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .unread-badge {
            background: #00aff5;
            color: white;
            font-size: 10px;
            font-weight: 800;
            padding: 2px 8px;
            border-radius: 10px;
            min-width: 20px;
            text-align: center;
        }

        .ride-tag {
            font-size: 9px;
            background: #f0f9ff;
            color: #00aff5;
            padding: 3px 8px;
            border-radius: 8px;
            font-weight: 600;
        }

        .empty-state {
            text-align: center;
            padding: 60px 20px;
            background: white;
            border-radius: 20px;
            margin-top: 20px;
        }

        .empty-icon {
            font-size: 48px;
            margin-bottom: 16px;
        }

        .empty-title {
            font-size: 18px;
            font-weight: 800;
            color: #1e3a5f;
            margin-bottom: 8px;
        }

        .empty-text {
            font-size: 13px;
            color: #64748b;
            margin-bottom: 20px;
        }

        .start-btn {
            display: inline-block;
            padding: 12px 24px;
            background: linear-gradient(135deg, #00aff5, #10b981);
            color: white;
            border-radius: 12px;
            font-size: 13px;
            font-weight: 700;
            text-decoration: none;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session('success')): ?>
        <div class="alert-success">✓ <?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="inbox-header">
        <h1 class="inbox-title">Messages</h1>
        <a href="<?php echo e(route('inbox.demo')); ?>" class="demo-btn">+ Add Demo Chats</a>
    </div>

    <?php if($conversations->count() > 0): ?>
        <div class="conversation-list">
            <?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $otherUser = $conversation->getOtherUser($user->id);
                    $unreadCount = $conversation->unreadCount($user->id);
                    $latestMessage = $conversation->latestMessage;
                ?>
                <a href="<?php echo e(route('inbox.show', $conversation->id)); ?>" class="conversation-item">
                    <div class="conversation-avatar">
                        <?php if($otherUser->avatar ?? false): ?>
                            <img src="<?php echo e(asset('storage/' . $otherUser->avatar)); ?>" alt="<?php echo e($otherUser->name); ?>">
                        <?php else: ?>
                            <?php echo e(substr($otherUser->name ?? 'U', 0, 1)); ?>

                        <?php endif; ?>
                    </div>
                    <div class="conversation-content">
                        <div class="conversation-header">
                            <span class="conversation-name"><?php echo e($otherUser->name ?? 'Unknown'); ?></span>
                            <span class="conversation-time">
                                <?php echo e($conversation->last_message_at ? $conversation->last_message_at->diffForHumans(null, true) : ''); ?>

                            </span>
                        </div>
                        <div class="conversation-preview">
                            <?php echo e($latestMessage ? Str::limit($latestMessage->content, 40) : 'No messages yet'); ?>

                        </div>
                        <?php if($conversation->ride): ?>
                            <span class="ride-tag">
                                🚗 <?php echo e($conversation->ride->route->fromCity->name ?? ''); ?> → <?php echo e($conversation->ride->route->toCity->name ?? ''); ?>

                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="conversation-meta">
                        <?php if($unreadCount > 0): ?>
                            <span class="unread-badge"><?php echo e($unreadCount); ?></span>
                        <?php endif; ?>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="empty-state">
            <div class="empty-icon">💬</div>
            <h2 class="empty-title">No Messages Yet</h2>
            <p class="empty-text">Start a conversation with drivers or passengers</p>
            <a href="<?php echo e(route('inbox.demo')); ?>" class="start-btn">Create Demo Chats</a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/inbox/index.blade.php ENDPATH**/ ?>