

<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Stats Grid -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon blue">👥</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_users'])); ?></div>
            <div class="stat-label">Total Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">🚗</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_drivers'])); ?></div>
            <div class="stat-label">Drivers</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">🎫</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_bookings'])); ?></div>
            <div class="stat-label">Total Bookings</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">🛣️</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_rides'])); ?></div>
            <div class="stat-label">Total Rides</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon blue">🚙</div>
            <div class="stat-value"><?php echo e(number_format($stats['total_vehicles'])); ?></div>
            <div class="stat-label">Vehicles</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">✅</div>
            <div class="stat-value"><?php echo e(number_format($stats['verified_users'])); ?></div>
            <div class="stat-label">Verified Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon orange">⏳</div>
            <div class="stat-value"><?php echo e(number_format($stats['pending_kyc'])); ?></div>
            <div class="stat-label">Pending KYC</div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">💰</div>
            <div class="stat-value">Rs <?php echo e(number_format($stats['revenue'])); ?></div>
            <div class="stat-label">Total Revenue</div>
        </div>
    </div>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 24px;">
        <!-- Recent Users -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Users</h3>
                <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-primary btn-sm">View All</a>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Type</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recent_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div class="user-cell">
                                    <div class="user-avatar-sm"><?php echo e(substr($user->name, 0, 1)); ?></div>
                                    <div>
                                        <div style="font-weight: 700;"><?php echo e($user->name); ?></div>
                                        <div style="font-size: 12px; color: #64748b;"><?php echo e($user->email); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge badge-info"><?php echo e(ucfirst($user->user_type)); ?></span>
                            </td>
                            <td>
                                <?php if($user->is_verified): ?>
                                    <span class="badge badge-success">Verified</span>
                                <?php else: ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" style="text-align: center; color: #64748b;">No users yet</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Recent Bookings -->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Recent Bookings</h3>
                <a href="<?php echo e(route('admin.bookings')); ?>" class="btn btn-primary btn-sm">View All</a>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Route</th>
                        <th>Passenger</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recent_bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <div style="font-weight: 700;">
                                    <?php echo e($booking->ride->route->fromCity->name ?? 'N/A'); ?> → <?php echo e($booking->ride->route->toCity->name ?? 'N/A'); ?>

                                </div>
                                <div style="font-size: 12px; color: #64748b;"><?php echo e($booking->number_of_seats); ?> seat(s)</div>
                            </td>
                            <td><?php echo e($booking->passenger->name ?? 'N/A'); ?></td>
                            <td>
                                <span class="badge badge-<?php echo e($booking->booking_status == 'confirmed' ? 'success' : 'warning'); ?>">
                                    <?php echo e(ucfirst($booking->booking_status)); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="3" style="text-align: center; color: #64748b;">No bookings yet</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Recent Rides -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Recent Rides</h3>
            <a href="<?php echo e(route('admin.rides')); ?>" class="btn btn-primary btn-sm">View All</a>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Driver</th>
                    <th>Date</th>
                    <th>Price</th>
                    <th>Seats</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $recent_rides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ride): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                <?php echo e($ride->route->fromCity->name ?? 'N/A'); ?> → <?php echo e($ride->route->toCity->name ?? 'N/A'); ?>

                            </div>
                        </td>
                        <td><?php echo e($ride->driver->name ?? 'N/A'); ?></td>
                        <td><?php echo e($ride->departure_datetime ? $ride->departure_datetime->format('M d, Y H:i') : 'N/A'); ?></td>
                        <td>Rs <?php echo e(number_format($ride->price_per_seat * 280)); ?></td>
                        <td><?php echo e($ride->available_seats); ?>/<?php echo e($ride->vehicle->seats ?? '?'); ?></td>
                        <td>
                            <span class="badge badge-<?php echo e($ride->ride_status == 'scheduled' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst($ride->ride_status)); ?>

                            </span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" style="text-align: center; color: #64748b;">No rides yet</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>