<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <title><?php echo $__env->yieldContent('title', 'KKH Ride'); ?> - Premium Carpooling</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        :root {
            --primary: #00aff5;
            --primary-dark: #0099d9;
            --secondary: #002f34;
            --bg-light: #f6f7f9;
            --text-main: #002f34;
            --text-muted: #70808c;
            --white: #ffffff;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * { margin: 0; padding: 0; box-sizing: border-box; -webkit-tap-highlight-color: transparent; }
        body { font-family: 'Plus Jakarta Sans', sans-serif; background: var(--bg-light); color: var(--text-main); line-height: 1.5; }

        /* Header */
        .header {
            position: fixed; top: 0; left: 0; right: 0; height: 60px;
            background: #ffffff; z-index: 1000; display: flex; align-items: center;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
        }

        .header-content {
            width: 100%; max-width: 1200px; margin: 0 auto;
            padding: 0 20px; display: flex; justify-content: space-between; align-items: center;
        }

        /* Animated Logo */
        .kkh-logo-2d {
            display: flex; flex-direction: column; text-decoration: none; padding: 8px 0;
        }

        .logo-svg-container { position: relative; width: 100px; height: 28px; }
        .logo-svg-container svg { position: absolute; top: -15px; left: -5px; width: 100px; height: 40px; overflow: visible; }

        .arch-path {
            stroke: #00aff5; stroke-width: 3.5; stroke-linecap: round; fill: none;
            stroke-dasharray: 300; stroke-dashoffset: 300;
            animation: drawArch 1.2s ease-out infinite;
        }

        .logo-dot {
            fill: #002f34; opacity: 0;
            animation: dotFadeIn 3s ease-out infinite;
        }

        .dot-1 { animation-delay: 0.7s; }
        .dot-2 { animation-delay: 0.9s; }
        .dot-3 { animation-delay: 1.1s; }

        @keyframes drawArch {
            0% { stroke-dashoffset: 300; }
            40% { stroke-dashoffset: 0; }
            100% { stroke-dashoffset: 0; }
        }

        @keyframes dotFadeIn {
            0% { opacity: 0; transform: scale(0.5); }
            30% { opacity: 1; transform: scale(1.2); }
            50% { opacity: 1; transform: scale(1); }
            100% { opacity: 1; transform: scale(1); }
        }

        .logo-text-2d { font-size: 26px; font-weight: 800; display: flex; align-items: center; gap: 2px; }
        .kkh-2d { color: #00aff5; }
        .ride-2d { color: #002f34; }
        .logo-tagline-2d { font-size: 9px; font-weight: 500; color: rgba(0, 47, 52, 0.5); letter-spacing: 1px; text-transform: uppercase; margin-top: -2px; }

        .btn { padding: 12px 24px; border-radius: 12px; font-weight: 700; font-size: 14px; text-decoration: none; transition: var(--transition); cursor: pointer; border: none; }
        .btn-primary { background: var(--primary); color: white; }
        .btn-primary:hover { background: var(--primary-dark); transform: translateY(-2px); box-shadow: 0 10px 20px rgba(0, 175, 245, 0.2); }

        /* Mobile Bottom Navigation */
        .mobile-bottom-nav {
            position: fixed; bottom: 0; left: 0; right: 0; height: 75px;
            background: #ffffff; z-index: 1000; display: none;
            justify-content: space-around; align-items: center;
            box-shadow: 0 -8px 40px rgba(0, 0, 0, 0.1);
            border-radius: 28px 28px 0 0;
            padding: 0 4px; padding-bottom: env(safe-area-inset-bottom, 0);
        }

        .nav-item {
            display: flex; flex-direction: column; align-items: center; gap: 3px;
            text-decoration: none; color: #b0b8c1; font-size: 10px; font-weight: 600;
            width: 18%; padding: 8px 6px; border-radius: 16px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
        }

        .nav-item.active { color: var(--primary); }
        .nav-item.active span { font-weight: 700; }

        .nav-item.active::before {
            content: ''; position: absolute; top: -2px; left: 50%; transform: translateX(-50%);
            width: 32px; height: 3px; background: linear-gradient(90deg, #00aff5, #10b981);
            border-radius: 0 0 4px 4px; animation: indicatorPulse 2s ease-in-out infinite;
        }

        @keyframes indicatorPulse {
            0%, 100% { opacity: 1; width: 32px; }
            50% { opacity: 0.7; width: 40px; }
        }

        .nav-item:active { transform: scale(0.85); }
        .nav-item-icon { width: 24px; height: 24px; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275); }

        .nav-item.active .nav-item-icon {
            transform: scale(1.15) translateY(-2px);
            filter: drop-shadow(0 4px 8px rgba(0, 175, 245, 0.4));
        }

        .publish-btn-mobile {
            background: linear-gradient(135deg, #00aff5 0%, #10b981 100%);
            color: white; width: 58px; height: 58px; border-radius: 20px;
            display: flex; align-items: center; justify-content: center;
            box-shadow: 0 8px 30px rgba(0, 175, 245, 0.45);
            margin-top: -36px; transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            animation: fabPulse 3s ease-in-out infinite; position: relative;
        }

        @keyframes fabPulse {
            0%, 100% { box-shadow: 0 8px 30px rgba(0, 175, 245, 0.45); transform: scale(1); }
            50% { box-shadow: 0 12px 40px rgba(0, 175, 245, 0.6); transform: scale(1.02); }
        }

        .publish-btn-mobile:active { transform: scale(0.9) rotate(90deg); }
        .publish-btn-mobile .nav-item-icon { color: white; width: 26px; height: 26px; }

        @media (max-width: 968px) {
            .mobile-bottom-nav { display: flex; }
            .header-content .desktop-nav { display: none; }
            
            /* Hide header on mobile for inner pages */
            .header { display: none; }
            
            html { scroll-behavior: smooth; }
            body { 
                -webkit-overflow-scrolling: touch;
                padding-bottom: env(safe-area-inset-bottom, 0);
            }
        }

        .main-content { padding-top: 80px; padding-bottom: 100px; min-height: 100vh; }
        .container { max-width: 1200px; margin: 0 auto; padding: 0 16px; }

        @media (max-width: 968px) {
            .main-content { 
                padding-top: 16px; 
                padding-bottom: 120px;
                min-height: calc(100vh - 75px);
            }
            .container { 
                padding: 0 12px;
                padding-bottom: 20px;
            }
        }

        <?php echo $__env->yieldContent('styles'); ?>
    </style>
</head>
<body>
    <header class="header">
        <div class="header-content">
            <a href="<?php echo e(route('home')); ?>" class="kkh-logo-2d">
                <div class="logo-svg-container">
                    <svg viewBox="0 0 200 60">
                        <path d="M5,45 Q5,10 160,10" class="arch-path" />
                        <circle cx="172" cy="12" r="3" class="logo-dot dot-1" />
                        <circle cx="185" cy="22" r="3" class="logo-dot dot-2" />
                        <circle cx="192" cy="38" r="3" class="logo-dot dot-3" />
                    </svg>
                </div>
                <div class="logo-text-2d">
                    <span class="kkh-2d">kkh</span>
                    <span class="ride-2d">ride</span>
                </div>
                <span class="logo-tagline-2d">Premium Travels</span>
            </a>
            <div class="desktop-nav">
                <a href="<?php echo e(route('rides.create')); ?>" class="btn btn-primary">Offer a Ride</a>
            </div>
        </div>
    </header>

    <main class="main-content">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>

    <div class="mobile-bottom-nav">
        <a href="<?php echo e(route('home')); ?>" class="nav-item <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                <polyline points="9 22 9 12 15 12 15 22"></polyline>
            </svg>
            <span>Home</span>
        </a>
        <a href="<?php echo e(route('rides.index')); ?>" class="nav-item <?php echo e(request()->routeIs('rides.index') || request()->routeIs('rides.search') ? 'active' : ''); ?>">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <circle cx="11" cy="11" r="8"></circle>
                <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
            </svg>
            <span>Rides</span>
        </a>
        <a href="<?php echo e(route('rides.create')); ?>" class="nav-item">
            <div class="publish-btn-mobile">
                <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3">
                    <line x1="12" y1="5" x2="12" y2="19"></line>
                    <line x1="5" y1="12" x2="19" y2="12"></line>
                </svg>
            </div>
            <span style="margin-top: 4px;">Offer</span>
        </a>
        <a href="<?php echo e(route('inbox')); ?>" class="nav-item <?php echo e(request()->routeIs('inbox') ? 'active' : ''); ?>">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
            </svg>
            <span>Inbox</span>
        </a>
        <a href="<?php echo e(auth()->check() ? route('profile') : route('login')); ?>" class="nav-item <?php echo e(request()->routeIs('profile') ? 'active' : ''); ?>">
            <svg class="nav-item-icon" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2.5">
                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                <circle cx="12" cy="7" r="4"></circle>
            </svg>
            <span><?php echo e(auth()->check() ? 'Profile' : 'Login'); ?></span>
        </a>
    </div>

    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH D:\gg\ridepool\resources\views/layouts/app.blade.php ENDPATH**/ ?>