

<?php $__env->startSection('title', 'Vehicles'); ?>
<?php $__env->startSection('page-title', 'Vehicles Management'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Vehicles (<?php echo e($vehicles->total()); ?>)</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Vehicle</th>
                    <th>Owner</th>
                    <th>License Plate</th>
                    <th>Seats</th>
                    <th>Color</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div style="font-weight: 700;"><?php echo e($vehicle->make); ?> <?php echo e($vehicle->model); ?></div>
                            <div style="font-size: 12px; color: #64748b;"><?php echo e($vehicle->year); ?></div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm"><?php echo e(substr($vehicle->driver->name ?? 'D', 0, 1)); ?></div>
                                <div>
                                    <div style="font-weight: 600;"><?php echo e($vehicle->driver->name ?? 'N/A'); ?></div>
                                    <div style="font-size: 12px; color: #64748b;"><?php echo e($vehicle->driver->phone ?? ''); ?></div>
                                </div>
                            </div>
                        </td>
                        <td style="font-weight: 700;"><?php echo e($vehicle->license_plate); ?></td>
                        <td><?php echo e($vehicle->seats); ?></td>
                        <td>
                            <div style="display: flex; align-items: center; gap: 8px;">
                                <div style="width: 20px; height: 20px; border-radius: 50%; background: <?php echo e(strtolower($vehicle->color)); ?>; border: 2px solid #e2e8f0;"></div>
                                <?php echo e($vehicle->color); ?>

                            </div>
                        </td>
                        <td>
                            <?php if($vehicle->is_verified): ?>
                                <span class="badge badge-success">Verified</span>
                            <?php else: ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(!$vehicle->is_verified): ?>
                                <form action="<?php echo e(route('admin.vehicles.verify', $vehicle->id)); ?>" method="POST" style="display: inline;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-primary btn-sm">Verify</button>
                                </form>
                            <?php else: ?>
                                <span style="color: #10b981; font-size: 13px; font-weight: 600;">✓ Verified</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" style="text-align: center; color: #64748b; padding: 40px;">No vehicles found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        <?php echo e($vehicles->links()); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\gg\ridepool\resources\views/admin/vehicles.blade.php ENDPATH**/ ?>