@extends('layouts.app')

@section('title', 'Your Profile')

@section('styles')
<style>
    /* BlaBlaCar Style Profile */
    .profile-hero {
        background: linear-gradient(135deg, #00aff5 0%, #0099d9 100%);
        border-radius: 0 0 32px 32px;
        padding: 24px 20px 80px;
        margin: -20px -12px 0;
        position: relative;
    }

    .profile-hero-content {
        display: flex;
        align-items: center;
        gap: 16px;
    }

    .profile-avatar-lg {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 32px;
        font-weight: 800;
        color: #00aff5;
        border: 4px solid rgba(255,255,255,0.3);
        position: relative;
        overflow: hidden;
    }

    .profile-avatar-lg img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .avatar-edit-btn {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: rgba(0,0,0,0.6);
        color: white;
        font-size: 9px;
        text-align: center;
        padding: 4px;
        cursor: pointer;
    }

    .profile-hero-info {
        flex: 1;
        color: white;
    }

    .profile-name-lg {
        font-size: 22px;
        font-weight: 800;
        margin-bottom: 4px;
    }

    .profile-member {
        font-size: 12px;
        opacity: 0.8;
    }

    .verified-lg {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        background: rgba(255,255,255,0.2);
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        margin-top: 8px;
    }

    /* Stats Card - Floating */
    .stats-card {
        background: white;
        border-radius: 20px;
        padding: 20px;
        margin: -50px 16px 16px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 16px;
    }

    .stat-item-lg {
        text-align: center;
    }

    .stat-value-lg {
        font-size: 24px;
        font-weight: 800;
        color: #1e3a5f;
    }

    .stat-label-lg {
        font-size: 11px;
        color: #64748b;
        font-weight: 600;
    }

    /* Menu List */
    .menu-section {
        padding: 0 4px;
    }

    .menu-title {
        font-size: 11px;
        font-weight: 700;
        color: #94a3b8;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin: 20px 12px 10px;
    }

    .menu-card {
        background: white;
        border-radius: 16px;
        overflow: hidden;
        box-shadow: 0 2px 10px rgba(0,0,0,0.04);
    }

    .menu-item {
        display: flex;
        align-items: center;
        gap: 14px;
        padding: 16px;
        text-decoration: none;
        color: #1e3a5f;
        border-bottom: 1px solid #f1f5f9;
        transition: background 0.2s;
    }

    .menu-item:last-child {
        border-bottom: none;
    }

    .menu-item:active {
        background: #f8fafc;
    }

    .menu-icon {
        width: 44px;
        height: 44px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
    }

    .menu-icon.blue { background: #e0f7fa; }
    .menu-icon.green { background: #d1fae5; }
    .menu-icon.purple { background: #ede9fe; }
    .menu-icon.orange { background: #fef3c7; }
    .menu-icon.red { background: #fee2e2; }
    .menu-icon.gray { background: #f1f5f9; }

    .menu-content {
        flex: 1;
    }

    .menu-label {
        font-size: 14px;
        font-weight: 700;
    }

    .menu-desc {
        font-size: 11px;
        color: #64748b;
    }

    .menu-arrow {
        color: #cbd5e1;
    }

    .menu-badge {
        background: #ef4444;
        color: white;
        font-size: 10px;
        font-weight: 700;
        padding: 2px 8px;
        border-radius: 10px;
    }

    /* User Type Switch */
    .type-switch {
        display: flex;
        background: #f1f5f9;
        border-radius: 12px;
        padding: 4px;
        margin: 16px 4px;
    }

    .type-option {
        flex: 1;
        padding: 12px;
        text-align: center;
        border-radius: 10px;
        font-size: 13px;
        font-weight: 700;
        color: #64748b;
        cursor: pointer;
        transition: all 0.2s;
    }

    .type-option.active {
        background: white;
        color: #00aff5;
        box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    }

    /* Trust Section */
    .trust-section {
        background: white;
        border-radius: 16px;
        padding: 20px;
        margin: 16px 4px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.04);
    }

    .trust-title {
        font-size: 16px;
        font-weight: 800;
        color: #1e3a5f;
        margin-bottom: 16px;
    }

    .trust-items {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .trust-item {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .trust-icon {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
    }

    .trust-icon.verified { background: #d1fae5; color: #10b981; }
    .trust-icon.pending { background: #fef3c7; color: #f59e0b; }
    .trust-icon.unverified { background: #f1f5f9; color: #94a3b8; }

    .trust-text {
        flex: 1;
        font-size: 13px;
        font-weight: 600;
        color: #1e3a5f;
    }

    .trust-action {
        font-size: 12px;
        font-weight: 700;
        color: #00aff5;
        text-decoration: none;
    }

    .alert-success {
        background: #d1fae5;
        color: #065f46;
        padding: 12px 16px;
        border-radius: 12px;
        font-size: 13px;
        font-weight: 600;
        margin: 16px 4px;
    }
</style>
@endsection

@section('content')
    @if(session('success'))
        <div class="alert-success">✓ {{ session('success') }}</div>
    @endif

    <!-- Hero Section -->
    <div class="profile-hero">
        <div class="profile-hero-content">
            <form action="{{ route('profile.avatar') }}" method="POST" enctype="multipart/form-data" id="avatarForm">
                @csrf
                <label class="profile-avatar-lg">
                    @if($user->avatar)
                        <img src="{{ asset('storage/' . $user->avatar) }}" alt="{{ $user->name }}">
                    @else
                        {{ substr($user->name, 0, 1) }}
                    @endif
                    <input type="file" name="avatar" style="display: none;" onchange="document.getElementById('avatarForm').submit()">
                    <span class="avatar-edit-btn">Edit</span>
                </label>
            </form>
            <div class="profile-hero-info">
                <div class="profile-name-lg">{{ $user->name }}</div>
                <div class="profile-member">Member since {{ $user->created_at->format('M Y') }}</div>
                @if($user->is_verified)
                    <div class="verified-lg">✓ Verified Profile</div>
                @endif
            </div>
        </div>
    </div>

    <!-- Stats Card -->
    <div class="stats-card">
        <div class="stat-item-lg">
            <div class="stat-value-lg">{{ $stats['total_rides'] }}</div>
            <div class="stat-label-lg">Total Rides</div>
        </div>
        <div class="stat-item-lg">
            <div class="stat-value-lg">⭐ {{ number_format($stats['rating'], 1) }}</div>
            <div class="stat-label-lg">Rating</div>
        </div>
        <div class="stat-item-lg">
            <div class="stat-value-lg">{{ $user->is_verified ? '✓' : '○' }}</div>
            <div class="stat-label-lg">{{ $user->is_verified ? 'Verified' : 'Unverified' }}</div>
        </div>
    </div>

    <!-- User Type Switch -->
    <form action="{{ route('profile.update') }}" method="POST" id="typeForm">
        @csrf
        <input type="hidden" name="name" value="{{ $user->name }}">
        <input type="hidden" name="email" value="{{ $user->email }}">
        <input type="hidden" name="phone" value="{{ $user->phone }}">
        <input type="hidden" name="user_type" id="userTypeInput" value="{{ $user->user_type }}">
        <div class="type-switch">
            <div class="type-option {{ $user->user_type == 'passenger' ? 'active' : '' }}" onclick="switchType('passenger')">🚶 Passenger</div>
            <div class="type-option {{ $user->user_type == 'driver' ? 'active' : '' }}" onclick="switchType('driver')">🚗 Driver</div>
            <div class="type-option {{ $user->user_type == 'both' ? 'active' : '' }}" onclick="switchType('both')">⚡ Both</div>
        </div>
    </form>

    <!-- Trust Section -->
    <div class="trust-section">
        <h3 class="trust-title">Trust & Verification</h3>
        <div class="trust-items">
            <div class="trust-item">
                <div class="trust-icon {{ $user->email ? 'verified' : 'unverified' }}">📧</div>
                <span class="trust-text">Email Confirmed</span>
                @if($user->email)
                    <span style="color: #10b981; font-size: 12px; font-weight: 700;">✓</span>
                @endif
            </div>
            <div class="trust-item">
                <div class="trust-icon {{ $user->phone ? 'verified' : 'unverified' }}">📱</div>
                <span class="trust-text">Phone Verified</span>
                @if($user->phone)
                    <span style="color: #10b981; font-size: 12px; font-weight: 700;">✓</span>
                @else
                    <a href="#" class="trust-action">Add</a>
                @endif
            </div>
            <div class="trust-item">
                @php $kycData = $user->verification_document ? json_decode($user->verification_document, true) : null; @endphp
                <div class="trust-icon {{ $user->is_verified ? 'verified' : ($kycData ? 'pending' : 'unverified') }}">🪪</div>
                <span class="trust-text">ID Verified</span>
                @if($user->is_verified)
                    <span style="color: #10b981; font-size: 12px; font-weight: 700;">✓</span>
                @elseif($kycData)
                    <span style="color: #f59e0b; font-size: 11px; font-weight: 600;">Pending</span>
                @else
                    <a href="{{ route('profile', ['tab' => 'kyc']) }}" class="trust-action">Verify</a>
                @endif
            </div>
        </div>
    </div>

    <!-- Account Menu -->
    <div class="menu-section">
        <div class="menu-title">Account</div>
        <div class="menu-card">
            <a href="{{ route('profile', ['tab' => 'profile']) }}" class="menu-item">
                <div class="menu-icon blue">👤</div>
                <div class="menu-content">
                    <div class="menu-label">Edit Profile</div>
                    <div class="menu-desc">Name, email, phone</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
            <a href="{{ route('profile', ['tab' => 'kyc']) }}" class="menu-item">
                <div class="menu-icon green">🪪</div>
                <div class="menu-content">
                    <div class="menu-label">KYC Verification</div>
                    <div class="menu-desc">Verify your identity</div>
                </div>
                @if(!$user->is_verified)
                    <span class="menu-badge">Required</span>
                @endif
                <span class="menu-arrow">›</span>
            </a>
            <a href="{{ route('profile', ['tab' => 'vehicles']) }}" class="menu-item">
                <div class="menu-icon purple">🚗</div>
                <div class="menu-content">
                    <div class="menu-label">My Vehicles</div>
                    <div class="menu-desc">{{ $user->vehicles->count() }} vehicle(s)</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
        </div>
    </div>

    <!-- Activity Menu -->
    <div class="menu-section">
        <div class="menu-title">Activity</div>
        <div class="menu-card">
            <a href="{{ route('dashboard') }}" class="menu-item">
                <div class="menu-icon orange">📊</div>
                <div class="menu-content">
                    <div class="menu-label">My Rides</div>
                    <div class="menu-desc">View your trips</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
            <a href="{{ route('inbox') }}" class="menu-item">
                <div class="menu-icon blue">💬</div>
                <div class="menu-content">
                    <div class="menu-label">Messages</div>
                    <div class="menu-desc">Your conversations</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
        </div>
    </div>

    <!-- Settings Menu -->
    <div class="menu-section">
        <div class="menu-title">Settings</div>
        <div class="menu-card">
            <a href="#" class="menu-item">
                <div class="menu-icon gray">🔔</div>
                <div class="menu-content">
                    <div class="menu-label">Notifications</div>
                    <div class="menu-desc">Push & email settings</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
            <a href="#" class="menu-item">
                <div class="menu-icon gray">🌐</div>
                <div class="menu-content">
                    <div class="menu-label">Language</div>
                    <div class="menu-desc">English</div>
                </div>
                <span class="menu-arrow">›</span>
            </a>
            <form action="{{ route('logout') }}" method="POST">
                @csrf
                <button type="submit" class="menu-item" style="width: 100%; border: none; background: none; cursor: pointer; text-align: left;">
                    <div class="menu-icon red">🚪</div>
                    <div class="menu-content">
                        <div class="menu-label" style="color: #ef4444;">Logout</div>
                        <div class="menu-desc">Sign out of your account</div>
                    </div>
                </button>
            </form>
        </div>
    </div>

    <div style="height: 20px;"></div>

    <script>
        function switchType(type) {
            document.getElementById('userTypeInput').value = type;
            document.getElementById('typeForm').submit();
        }
    </script>
@endsection
