@extends('admin.layout')

@section('title', 'Bookings')
@section('page-title', 'Bookings Management')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">All Bookings ({{ $bookings->total() }})</h3>
        </div>
        <table class="table">
            <thead>
                <tr>
                    <th>Route</th>
                    <th>Passenger</th>
                    <th>Driver</th>
                    <th>Seats</th>
                    <th>Price</th>
                    <th>Payment</th>
                    <th>Status</th>
                    <th>Booked On</th>
                </tr>
            </thead>
            <tbody>
                @forelse($bookings as $booking)
                    <tr>
                        <td>
                            <div style="font-weight: 700;">
                                {{ $booking->ride->route->fromCity->name ?? 'N/A' }} → {{ $booking->ride->route->toCity->name ?? 'N/A' }}
                            </div>
                            <div style="font-size: 12px; color: #64748b;">
                                {{ $booking->ride->departure_datetime ? $booking->ride->departure_datetime->format('M d, Y') : 'N/A' }}
                            </div>
                        </td>
                        <td>
                            <div class="user-cell">
                                <div class="user-avatar-sm">{{ substr($booking->passenger->name ?? 'P', 0, 1) }}</div>
                                <div>
                                    <div style="font-weight: 600;">{{ $booking->passenger->name ?? 'N/A' }}</div>
                                    <div style="font-size: 12px; color: #64748b;">{{ $booking->passenger->phone ?? '' }}</div>
                                </div>
                            </div>
                        </td>
                        <td>{{ $booking->ride->driver->name ?? 'N/A' }}</td>
                        <td style="font-weight: 700;">{{ $booking->number_of_seats }}</td>
                        <td style="font-weight: 700; color: #10b981;">Rs {{ number_format($booking->total_price * 280) }}</td>
                        <td>
                            @if($booking->payment_status == 'paid')
                                <span class="badge badge-success">Paid</span>
                            @elseif($booking->payment_status == 'pending')
                                <span class="badge badge-warning">Pending</span>
                            @else
                                <span class="badge badge-danger">{{ ucfirst($booking->payment_status) }}</span>
                            @endif
                        </td>
                        <td>
                            @if($booking->booking_status == 'confirmed')
                                <span class="badge badge-success">Confirmed</span>
                            @elseif($booking->booking_status == 'completed')
                                <span class="badge badge-info">Completed</span>
                            @elseif($booking->booking_status == 'cancelled')
                                <span class="badge badge-danger">Cancelled</span>
                            @else
                                <span class="badge badge-warning">{{ ucfirst($booking->booking_status) }}</span>
                            @endif
                        </td>
                        <td style="font-size: 13px; color: #64748b;">{{ $booking->created_at->format('M d, Y') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="8" style="text-align: center; color: #64748b; padding: 40px;">No bookings found</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div style="display: flex; justify-content: center; margin-top: 20px;">
        {{ $bookings->links() }}
    </div>
@endsection
