<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('driver_id')->constrained('users')->onDelete('cascade');
            $table->enum('vehicle_type', ['sedan', 'suv', 'hatchback', 'van', 'mini-bus'])->default('sedan');
            $table->string('brand', 100);
            $table->string('model', 100);
            $table->year('year');
            $table->string('color', 50);
            $table->string('license_plate', 50)->unique();
            $table->string('registration_number', 100)->unique();
            $table->integer('total_seats')->default(4);
            $table->json('vehicle_images')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_verified')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
